package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.biz.event.OrderTmpToFormalEvent;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.params.OrderSmsParam;
import com.qiho.center.common.support.BizEventBus;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @author chensong
 * @create 2018-05-22 14:27
 **/
@Component
public class OrderSmsTimeOutBo {

    private final static Logger LOGGER = LoggerFactory.getLogger(OrderSmsTimeOutBo.class);

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;

    @Autowired
    private OrderTmpService orderTmpService;

    @Autowired
    private BizEventBus eventBus;

    /**
     * 执行临时订单超时任务
     */
    public void doJob(){

        // 获取数据
        List<BaiqiOrderSmsEntity> orderSmsEntities = getProcessData();
        if (CollectionUtils.isEmpty(orderSmsEntities)) {
            // 没有数据 结束
            return ;
        }

        for (BaiqiOrderSmsEntity baiqiOrderSmsEntity : orderSmsEntities) {

            try{

                String orderId = baiqiOrderSmsEntity.getOrderId();
                OrderTmpDetailDto orderTmpDetailDto = orderTmpService.findByOrderId(orderId);
                if (null == orderTmpDetailDto || orderTmpDetailDto.getOrderStatus().intValue() != OrderTmpStatusEnum.TO_FILTER.getNum()) {
                    // 数据不存在 或者 临时订单不是待过滤状态 跳过
                    continue;
                }

                // 更改order_sms 的receive_status状态
                baiqiOrderSmsEntity.setReceiveStatus(OrderSmsReceiveStatus.PROCESSES.getNum());
                baiqiOrderSmsEntity.setMobileStatus(SmsMobileStatusEnum.TIME_OUT.getNum());
                baiqiOrderSmsMapper.updateMobileStatus(baiqiOrderSmsEntity);

                // 超时的订单直接通过手机号校验 走业务校验
                boolean bizCheckResult = orderTmpService.bizValidate(orderTmpDetailDto);
                if (!bizCheckResult) {
                    continue;
                }

                // 通过业务校验 发布临时订单变成正式订单事件
                // 业务校验成功 将订单变更为正式订单
                OrderTmpToFormalEvent toFormalEvent = new OrderTmpToFormalEvent();
                toFormalEvent.setOrderId(orderId);
                eventBus.post(toFormalEvent);
                LOGGER.info("临时订单由定时任务变更成正式订单，orderId： {} ", orderId);

            } catch (Exception e){
                LOGGER.warn("临时订单超时任务执行异常，orderId:{},", baiqiOrderSmsEntity.getOrderId(), e);
            }

        }
    }

    /**
     *  获取待处理的数据
     *  获取order_sms表最近2-10分钟短信服务商未返回消息的记录
     */
    private List<BaiqiOrderSmsEntity> getProcessData(){

        OrderSmsParam param = new OrderSmsParam();
        param.setReceiveStatus(OrderSmsReceiveStatus.UNPROCESSES.getNum());
        param.setSmsType(SmsTypeEnum.CHUANG_LAN.getNum());
        Date date = new Date();
        Date endTime = DateUtils.minutesAddOrSub(date,-2);
        Date startTime = DateUtils.minutesAddOrSub(date, -10);
        param.setEndTime(endTime);
        param.setStartTime(startTime);

        return baiqiOrderSmsMapper.findByParam(param);
    }






}
