package com.qiho.center.biz.bo;

import com.qiho.center.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: wangjin
 * @create 2018-08-21 11:49
 **/
@Component
@RefreshScope
public class SmsItemFilterBo {

    @Value("${baiqi.sms.item}")
    private String itemIds;


    /**
     * 校验itemId是否有效
     * @param itemId
     * @return
     */
    public Boolean validItem(Long itemId){

        List<Long> itemIdList = StringUtil.stringToListOrderByIds(itemIds);
        if (!CollectionUtils.isEmpty(itemIdList) && itemIdList.contains(itemId)) {
            return true;
        }
        return false;
    }

}
