package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.enums.blacklist.SourceTypeEnum;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBlackListMapper;
import com.qiho.center.common.daoh.qihostatistics.blacklist.BaiqiBlackListTmpMapper;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBlackListEntity;
import com.qiho.center.common.entityd.qihostatistics.SimpleBlackListTmpEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 黑名单同步任务
 * Created by Messi on 2018/5/1.
 */
@Component
public class SyncBlackListBo {



    @Autowired
    private BaiqiBlackListTmpMapper baiqiBlackListTmpMapper;

    @Autowired
    private BaiqiBlackListMapper baiqiBlackListMapper;


    /**
     * 黑名单同步任务处理
     */
    public void executeTask(){

        // 0.将之前的策略黑名单清空
        clearStrategyBlackList();

        //  1.查询静态库策略黑名单的数据
        Date endTime = new Date();
        Date startTime = DateUtils.hoursAddOrSub(endTime, -6);
        // 捞取最近6小时的临时表数据
        List<SimpleBlackListTmpEntity> simpleBKList = baiqiBlackListTmpMapper.listAllGroupByMerchantId(startTime, endTime);
        if (CollectionUtils.isEmpty(simpleBKList)) {
            return ;
        }

        //  1.1 以商家id分组查询策略黑名单的数据
        for (SimpleBlackListTmpEntity simpleBlackList : simpleBKList) {

            List<String> existValue = baiqiBlackListMapper.findSimpleValueByMerchantid(simpleBlackList.getMerchantId());
            List<String> tmpValue = baiqiBlackListTmpMapper.listValueByMerchantId(simpleBlackList.getMerchantId(),startTime, endTime);

            //  2.比对业务库已有的黑名单数据，去重操作
            tmpValue.removeAll(existValue);

            if (CollectionUtils.isNotEmpty(tmpValue)) {
                //  3.将新的黑名单数据写入业务库
                baiqiBlackListMapper.insertBatch(buildInsertStrategyParam(simpleBlackList.getMerchantId(),tmpValue));

            }
        }
    }


    /**
     * 清空原先的策略黑名单
     */
    private void clearStrategyBlackList(){
        List<BaiqiBlackListEntity> blackListEntities = baiqiBlackListMapper.listAllStrategyBlackList();
        if (CollectionUtils.isEmpty(blackListEntities)) {
            return ;
        }

        List<Long> idList = blackListEntities.stream().map(BaiqiBlackListEntity::getId).collect(Collectors.toList());
        baiqiBlackListMapper.batchDeleteByIds(idList,"策略删除");
    }



    /**
     * 构建批量插入参数
     * @param merchantId
     * @param valueList
     * @return
     */
    private List<BaiqiBlackListEntity> buildInsertStrategyParam(Long merchantId, List<String> valueList){
        return valueList.stream().map(e->{
            BaiqiBlackListEntity blackList = new BaiqiBlackListEntity();
            blackList.setBkValue(e);
            blackList.setMerchantId(merchantId);
            blackList.setBkType(BaiqiBlackListTypeEnum.PHONE.getNum());
            blackList.setSourceType(SourceTypeEnum.STRATEGY.getNum());
            blackList.setDealType(DealTypeEnum.FORBID_SUBMIT.getNum());
            blackList.setOperator("策略添加");
            blackList.setUseType(merchantId.longValue() > 0L ? BlackListUseTypeEnum.PART.getNum() : BlackListUseTypeEnum.ALL.getNum());
            return blackList;
        }).collect(Collectors.toList());
    }




}
