package com.qiho.center.biz.engine.action;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/** 24小时同一手机号同一商品校验
 * @author chensong
 * @create 2018-04-20 11:28
 **/
public class CountPhoneItemAction extends ShotOrderAbstractAction  {


    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;


    @Override
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        // 获取24小时同一手机号同一商品 下单量
        Long itemId = orderSnapshotDto.getItemId();

        Date startTime = DateUtils.daysAddOrSub(new Date(),-1);
        int count  = qihoOrderSnapshotDAO.countByMobileAndItem(orderSnapshotDto.getMobile(),itemId,startTime);


        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), count);
    }

}
