package com.qiho.center.biz.engine.action;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.common.daoh.qiho.anticheate.AnticheateMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiFilterRuleHitMapper;
import com.qiho.center.common.entityd.qiho.anticheate.AnticheateEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiFilterRuleHitEntity;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**  手机号多次命中规则校验
 *
 * @author chensong
 * @create 2018-07-13
 */
public class MobileDuplicateAction extends ShotOrderAbstractAction {

    private static final Logger LOGGER = LoggerFactory.getLogger(MobileDuplicateAction.class);

    /** 要排除统计的策略规则 */
    private static final List<String> excludeStrategyName = Lists.newArrayList(
            "同一用户24小时重复下单", "收货人手机号归属地和收货地址不匹配（精确到市）", "短信捞单-24小时推啊id=2",
            "同一手机号24小时下单大于等于3"
    );

    @Autowired
    private AnticheateMapper anticheateMapper;

    @Autowired
    private BaiqiFilterRuleHitMapper baiqiFilterRuleHitMapper;

    /**
     * 统计该手机号24小时内 命中过滤规则和踢单规则的数量
     *      排除掉 “同一用户24小时重复下单 收货人手机号归属地和收货地址不匹配（精确到市）
     *      短信捞单-24小时推啊id=2 同一手机号24小时下单大于等于3” 这些规则再统计
     * @param orderSnapshotDto
     * @param strategyRuleDto
     * @return
     */
    @Override
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {

        // 根据手机号查询24小时内的 过滤规则命中表和踢单规则命中表的数据
        String timeString = DateTime.now().minusDays(1).toString("yyyy-MM-dd hh:mm:ss");
        String mobile = orderSnapshotDto.getMobile();

        // 过滤规则命中信息
        List<AnticheateEntity> anticheateEntities = anticheateMapper.selectByMobileAndTime(mobile, timeString);
        // 踢单规则命中信息
        List<BaiqiFilterRuleHitEntity> filterRuleHitEntities = baiqiFilterRuleHitMapper.findByMobileAndTime(mobile, timeString);

        if (CollectionUtils.isEmpty(anticheateEntities) && CollectionUtils.isEmpty(filterRuleHitEntities)) {
            // 该手机号24h没有命中策略规则  返回通过的结果
            return ResultBase.rightReturn(false);
        }

        // 遍历过滤规则命中信息&踢单规则命中信息  统计命中规则数
        Set<String> orderIdSet = new HashSet<>();
        for (AnticheateEntity anticheate : anticheateEntities) {
            if (excludeStrategyName.contains(anticheate.getRule())) {
                continue;
            }
            orderIdSet.add(anticheate.getOrderId());
        }
        for (BaiqiFilterRuleHitEntity filterRuleHit : filterRuleHitEntities) {
            if (excludeStrategyName.contains(filterRuleHit.getRule())) {
                continue;
            }
            orderIdSet.add(filterRuleHit.getOrderId());
        }

        int hitNum = orderIdSet.size();
        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName())
                .valuteOrderByQuery(strategyRuleDto.getThreshold().trim(), hitNum);
    }



}
