package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 订单手机号校验
 *
 * @author peanut.huang
 * @date 2018/3/16.
 */
public class OrderMobileAction extends ShotOrderAbstractAction {


    private static final Logger logger = LoggerFactory.getLogger(OrderMobileAction.class);

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;


    /**
     * 订单手机号校验（通过手机号发短信返回的状态码判断）
     *
     * @return
     */
    @Override
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {

        //阈值
        String threshold = strategyRuleDto.getThreshold();

        // 短信状态码 从order_sms表获取
        BaiqiOrderSmsEntity orderSmsEntity = baiqiOrderSmsMapper.findByOrderId(orderSnapshotDto.getOrderId());
        if (null == orderSmsEntity
                || orderSmsEntity.getSmsType().intValue() != SmsTypeEnum.CHUANG_LAN.getNum()) {
            // 没有数据,或者不是创蓝发的短信，都返回通过的结果
            return  ResultBase.rightReturn(false);
        }
        String smsRetCode = SmsMobileStatusEnum.getByNum(orderSmsEntity.getMobileStatus()).getCode();

        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(threshold,smsRetCode);
    }

}
