package com.qiho.center.biz.engine.chain;

import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import com.qiho.center.api.enums.ShotOrder.ShotOrderValute;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.ProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Created by danke on 2017/6/21.
 * 自定义复杂校验处理器
 */
public class CustomHandler implements BaseHandler {

    private Map<String,ShotOrderValute> shotOrderValuteMap;

    private final static Logger LOGGER = LoggerFactory.getLogger(CustomHandler.class);

    @Override
    public ResultBase<Boolean> handleRequest(ProcessContext context){
        try{
            StrategyRuleDto strategyRuleDto = context.getStrategyRuleDto();
            ShotOrderFieldEnum shotOrderFieldEnum = ShotOrderFieldEnum.fromVal(strategyRuleDto.getFieldName());
            if (null== shotOrderFieldEnum)
                return ResultBase.errorReturn("没有找到对应的field校验配置,请检查策略是否存在脏数据 fieldName="+strategyRuleDto.getFieldName());


            String valuteKey = ShotOrderFieldEnum.fromVal(strategyRuleDto.getFieldName()).getKey();
            ShotOrderValute shotOrderValute = shotOrderValuteMap.get(valuteKey);
            if(null == shotOrderValute)//没有action,默认FALSE,因为没有校验,不能打标
                return ResultBase.rightReturn(Boolean.FALSE);

            ResultBase<Boolean> resultBase = shotOrderValute.valuteCostomByQuery(context.getOrderSnapshotDto(),context.getStrategyRuleDto());
            if (resultBase.getValue()) {
                // 表示命中规则
                resultBase.setHitField(ShotOrderFieldEnum.fromVal(strategyRuleDto.getFieldName()));
            }
            return resultBase;

        }catch(Exception e){
            throw new QihoException("策略处理异常",e);
        }
    }

    public Map<String, ShotOrderValute> getShotOrderValuteMap() {
        return shotOrderValuteMap;
    }

    public void setShotOrderValuteMap(Map<String, ShotOrderValute> shotOrderValuteMap) {
        this.shotOrderValuteMap = shotOrderValuteMap;
    }
}
