package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyCheckResultDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.enums.StrategyUseType;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.chain.BusEntiyHandler;
import com.qiho.center.biz.service.order.StrategyMerchantService;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;
import com.qiho.center.common.enums.InnerLogTypeEnum;
import com.qiho.center.common.log.InnerLog;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by qianjue on 2017/8/2.
 */
public class AheadPreventOrderEngine extends BaseOrderEngine implements BaseEngine<StrategyCheckResultDto>{


	private Logger logger = LoggerFactory.getLogger(AheadPreventOrderEngine.class);

	/**
	 * 校验链路入口类
	 * @param valuteData
	 * {@link BusEntiyHandler}
	 * @return
	 */
	private BaseHandler                  baseHandler;

	@Autowired
	private StrategyMerchantService      strategyMerchantService;


	@Override
	public StrategyCheckResultDto process(StrategyCheckResultDto result){

			if(null == result || null==result.getOrderSnapshotDto()) {
				return result;
			}
			result.setSuccess(true);
			try{
				//查询所有策略(下单),循环校验
				// ---->这个其实是对应页面上的规则 ，一个规则下面可能多个策略
				List<OrderStrategyDto> orderStrategyDtos = getOrderStrategyList(StrategyType.AHEAD_PREVENT_ORDER);

				//查询校验策略,如果为空,直接返回
				if (CollectionUtils.isEmpty(orderStrategyDtos)){
					return result;
				}
				return checkStrategy(result,orderStrategyDtos);
				//循环执行校验策略
			}catch (Exception e){
				logger.error("策略过滤链路失败, data={}",result.toString(), e);
			}
			return result;
		}


	private StrategyCheckResultDto checkStrategy(StrategyCheckResultDto result,List<OrderStrategyDto> orderStrategyDtos) {
		for (OrderStrategyDto orderStrategyDto : orderStrategyDtos){
			// 循环遍历每一条规则
			//判断当前订单是否匹配策略 --- add by peanut.huang on 2018.03.15
			Boolean match = isOrderMatchStrategy(orderStrategyDto, result.getOrderSnapshotDto());
			if(!match){
				continue;
			}

			Boolean flag = Boolean.TRUE;//用来标记返回值,falg决定后续对订单的处理
			ResultBase<List<StrategyRuleDto>> resultBase = validateorderStrategyDto(orderStrategyDto);
			if(!resultBase.hasSuccessValue()) {
				logger.warn(resultBase.getErrorMsg());
				continue;
			}
			List<StrategyRuleDto> strategyRuleDtos =resultBase.getValue();
			ResultBase<Boolean> checkResult = null;
			for (StrategyRuleDto strategyRuleDto : strategyRuleDtos){
				// 校验每一条策略
				//真正校验执行
				ProcessContext processContext = createProcessContext(result, orderStrategyDto, strategyRuleDto);

				//策略入口链路开始
				checkResult = baseHandler.handleRequest(processContext);
				if (checkResult.hasSuccessValue()){
					flag = flag && checkResult.getValue();
				}else{
					flag = Boolean.FALSE;
					logger.warn("本条策略规则校验失败 msg={} strategyName={} ruleName={} fieldName={}",
							checkResult.getErrorMsg(),orderStrategyDto.getStrategyName(),strategyRuleDto.getRuleName(),strategyRuleDto.getFieldName());
					break;//跳出本策略的循环,其中一环错误,校验无意义
				}

			}
			//校验发现一处错误即可以跳出整个校验逻辑,返回结果
			//目前下单前置校验只有在线支付这一种处理方式,因此默认返回接口,提示错误
			//后续如果出现其他处理的方式,则需要重新扩展处理
			if (flag){

				return packageResult(result,orderStrategyDto,checkResult);
			}
		}
		return result;
	}

	/**
	 * 封装返回结果
	 * @param result
	 * @param orderStrategyDto
	 * @param checkResult
	 * @return
	 */
	private StrategyCheckResultDto packageResult(StrategyCheckResultDto result, OrderStrategyDto orderStrategyDto,ResultBase<Boolean> checkResult){
		JSONObject logInfo = new JSONObject();
		logInfo.put("order", result.getOrderSnapshotDto());
		logInfo.put("rule", orderStrategyDto);
		InnerLog.log(InnerLogTypeEnum.SUBMIT_ORDER_RULE, logInfo);
		result.setSuccess(false);
		result.setShotOrderHandlerEnum(ShotOrderHandlerEnum.fromVal(orderStrategyDto.getHandlerName()));
		result.setShotOrderField(checkResult==null?null:checkResult.getHitField());
		return result;
	}


	private ProcessContext createProcessContext(StrategyCheckResultDto result, OrderStrategyDto orderStrategyDto, StrategyRuleDto strategyRuleDto) {
		// 适用部分商家
		if(StrategyUseType.PART.equals(StrategyUseType.findByValue(orderStrategyDto.getUseType()))) {
			strategyRuleDto.setPartMerchant(true);
		}else {
			strategyRuleDto.setPartMerchant(false);
		}
		return ProcessFaceory.createProcessContext(result.getOrderSnapshotDto(),strategyRuleDto,orderStrategyDto);
	}


	/**
	 * 订单是否匹配策略
	 *
	 * @param orderStrategyDto
	 * @param orderSnapshotDto
	 * @return
	 */
	private boolean isOrderMatchStrategy(OrderStrategyDto orderStrategyDto, OrderSnapshotDto orderSnapshotDto) {

		StrategyUseType useType = StrategyUseType.findByValue(orderStrategyDto.getUseType());

		//适用部分商家的策略
		if(StrategyUseType.PART.equals(useType)){

			// 商家id
			Long merchantId = orderSnapshotDto.getMerchantId();

			// 策略id
			Long strategyId = orderStrategyDto.getId();

			//find
			StrategyMerchantEntity strategyMerchantEntity = strategyMerchantService.find(merchantId, strategyId);

			return strategyMerchantEntity != null;
		}

		return true;
	}

	public BaseHandler getBaseHandler() {
		return baseHandler;
	}

	public void setBaseHandler(BaseHandler baseHandler) {
		this.baseHandler = baseHandler;
	}

	public StrategyMerchantService getStrategyMerchantService() {
		return strategyMerchantService;
	}

	public void setStrategyMerchantService(StrategyMerchantService strategyMerchantService) {
		this.strategyMerchantService = strategyMerchantService;
	}
}
