package com.qiho.center.biz.engine.task;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.service.order.AnticheateService;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;

import javax.annotation.Resource;

/**
 * Created by danke on 2017/9/8.
 * 短信捞单处理方式
 * 1.将规则名字记录命中规则字段
 * 2.更新订单快照表的处理方式字段为短信捞单
 * 3.发送短信给云片
 */
public class OrderNoteGainTask implements BaseEngine<ProcessContext>{

    @Resource
    private AnticheateService anticheateService;

    @Override
    public ProcessContext process(ProcessContext processContext) {
        if(null == processContext || null == processContext.getOrderSnapshotDto() || null == processContext.getStrategyDto()){
            return processContext;
        }
        OrderSnapshotDto orderSnapshotDto = processContext.getOrderSnapshotDto();
        QihoAnticheateEntity qihoAnticheateEntity = new QihoAnticheateEntity();
        qihoAnticheateEntity.setOrderId(orderSnapshotDto.getOrderId());
        qihoAnticheateEntity.setRule(processContext.getStrategyDto().getStrategyName());
        qihoAnticheateEntity.setMobile(orderSnapshotDto.getMobile());
        anticheateService.insert(qihoAnticheateEntity);
        return processContext;
    }

}
