package com.qiho.center.biz.event;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

import com.google.common.collect.Sets;

/**
 * Created by liuyao on 2017/5/23.
 * 商品删除事件
 */
public class ItemDeleteEvent implements Serializable {

    private static final long serialVersionUID = 8925321100398184016L;

    private Set<Long> items = Sets.newHashSet();

    /**
     * 添加商品Id
     * @param itemId
     */
    public void addItemId(Long itemId){
        items.add(itemId);
    }

    public void addAllItemId(Collection<Long> itemIds){
        items.addAll(itemIds);
    }

    /**
     * 获取所有的itemId
     * @return
     */
    public Set<Long> getItems(){
        return this.items;
    }

}
