/**
 * Project Name:qiho-center-biz File Name:OrderCreateEvent.java Package Name:com.qiho.center.biz.event
 * Date:2017年6月3日上午11:16:18 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.event;

import java.io.Serializable;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.common.annotations.AsyncEvent;

/**
 * ClassName:OrderCreateEvent <br/>
 * 新增订单事件. <br/>
 * Date: 2017年6月3日 上午11:16:18 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@AsyncEvent
public class OrderCreateEvent implements Serializable {

    /**
     */
    private static final long serialVersionUID = 5344848277270695318L;

    /** 订单快照 */
    private OrderSnapshotDto  orderSnapshot;

    /** 客户端JS生成的唯一ID，用户查询设备指纹ID */
    private String            tokenId;

    /**
     * orderSnapshot.
     *
     * @return the orderSnapshot
     */
    public OrderSnapshotDto getOrderSnapshot() {
        return orderSnapshot;
    }

    /**
     * orderSnapshot.
     *
     * @param orderSnapshot the orderSnapshot to set
     */
    public void setOrderSnapshot(OrderSnapshotDto orderSnapshot) {
        this.orderSnapshot = orderSnapshot;
    }

    /**
     * tokenId.
     *
     * @return the tokenId
     */
    public String getTokenId() {
        return tokenId;
    }

    /**
     * tokenId.
     *
     * @param tokenId the tokenId to set
     */
    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

}
