package com.qiho.center.biz.event;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.common.annotations.AsyncEvent;

import java.io.Serializable;

/** 从临时订单创建的正式订单事件
 * @author chensong
 * @create 2018-05-17 11:04
 **/
@AsyncEvent
public class OrderCreateFromTmpEvent implements Serializable {

    private static final long serialVersionUID = 3782961964980088291L;

    /** 订单快照 */
    private OrderSnapshotDto orderSnapshot;

    /** 客户端JS生成的唯一ID，用户查询设备指纹ID */
    private String            tokenId;

    public OrderSnapshotDto getOrderSnapshot() {
        return orderSnapshot;
    }

    public void setOrderSnapshot(OrderSnapshotDto orderSnapshot) {
        this.orderSnapshot = orderSnapshot;
    }

    public String getTokenId() {
        return tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }
}
