package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.common.daoh.qiho.BusinessLogMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 业务日志清理任务
 * Created by weny.cai on 2018/1/4.
 */
@Component
public class BusinessLogClearJob extends AbstractQihoSimpleElasticJob{

    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessLogClearJob.class);

    @Resource
    BusinessLogMapper businessLogMapper;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(Calendar.MONTH, -1);
        String clearDate = DateUtils.getSecondStr(ca.getTime());
        int result = businessLogMapper.deleteByClearDate(clearDate);
        LOGGER.info("清理了{}条业务日志数据",result);
    }

}