/**
 * Project Name:qiho-center-biz File Name:ErpAutoDeliveryJob.java Package Name:com.qiho.center.biz.job
 * Date:2017年6月27日下午3:35:58 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.job;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import cn.com.duiba.wolf.utils.DateUtils;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.util.AppLogUtil;

/**
 * ClassName:ErpAutoDeliveryJob <br/>
 * ERP自动发货. <br/>
 * Date: 2017年6月27日 下午3:35:58 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class ErpAutoDeliveryJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOG                 = LoggerFactory.getLogger(ErpAutoDeliveryJob.class);
    @Autowired
    private ErpOrderBo          erpOrderBo;

    @Autowired
    private QihoErpOrderDAO     qihoErpOrderDAO;

    @Resource
    private ExecutorService     executorService;

    /** 自动发货上限 */
    private static final int    AUTO_DELIVERY_LIMIT = 200;
    /** 活动线程数阈值，当活动线程数达到该值时，定时任务暂缓执行 */
    private static final int    MAX_ACTIVITY_COUNT  = 20;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        int threadCount = ((ThreadPoolExecutorWrapper) executorService).getActiveCount();
        if (threadCount >= MAX_ACTIVITY_COUNT) {
            AppLogUtil.warn(LOG, "################ 当前活动线程数：{}，达到阈值{}，定时任务暂缓执行 ################", threadCount,
                            MAX_ACTIVITY_COUNT);
            return;
        }
        List<QihoErpOrderEntity> erpList = qihoErpOrderDAO.findAutoDeliveryLimit(AUTO_DELIVERY_LIMIT, DateUtils.daysAddOrSub(new Date(), -3));
        if (CollectionUtils.isEmpty(erpList)) {
            return;
        }
        for (QihoErpOrderEntity erpOrder : erpList) {
            erpOrderBo.autoDelivery(erpOrder);
        }
    }
    
}
