package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsSubscribeMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsSubscribeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 快递订阅任务
 * @author: wangjin
 * @create 2018-06-12 11:48
 **/
@Component
public class ExpressPostOrderJob extends AbstractQihoSimpleElasticJob{

    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressPostOrderJob.class);

    @Resource
    private ExpressBo expressBo;
    @Resource
    private BaiqiLogisticsSubscribeMapper subscribeMapper;


    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        //只有线上环境才执行
//        if (!Environment.isOnline()){
//            return;
//        }
        LOGGER.info("快递订阅任务 开始");
        int pageSize = 150;
        long minId = 0;
        while (true) {
            List<BaiqiLogisticsSubscribeEntity> list = subscribeMapper.queryLogisticsNeedToPostOrder(pageSize,minId);
            if (CollectionUtils.isEmpty(list)) {
                break;
            }
            expressBo.subscribeExpress(BeanUtils.copyList(list,LogisticsOrderDo.class));
            minId = list.get(list.size()-1).getId();
        }
    }
}
