package com.qiho.center.biz.job;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import com.qiho.center.common.constant.Environment;
import com.qiho.center.common.es.CanalESSync;

/**
 * 订单快照binlog使用Canal同步ES任务，每秒执行一次，所以数据会有一秒左右的延迟，
 * 相关业务要与产品沟通，找到方案，达成一致
 *
 * <p>canal暂时没有集群方案，只有HA主备方案</p>
 *
 * <p>
 * canal消费端集群环境下只会有一台机器去消费binlog，比如：center有A,B两台机器，canal Server接收到binlog，
 * A,B两台机器中只有一台机器去拉数据（比如A）, 另一台机器做为备，当且仅当A宕机，B机器才会顶上去消费。
 * </p>
 *
 * <p>
 * 因些通过elasticJob分布式任务的方式去决定A,B哪台机器执行任务，去拉取数据
 * </p>
 *
 * @author peanut.huang
 * @date 2018/9/5.
 */
@Component
public class OrderSnapshotBinlogSyncJob extends AbstractSimpleElasticJob {

    @Resource
    private CanalESSync canalESSync;

    @Override
    public void process(JobExecutionMultipleShardingContext shardingContext) {
        // 预发环境与开发环境不执行
        if(Environment.isPrepub() ||  Environment.isDev()){
            return;
        }

       canalESSync.doProcess();
    }
}
