package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.biz.bo.EdbItemStockBo;
import com.qiho.center.biz.bo.SyncStockBo;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by weny.cai on 2017/8/9.
 */
@Component
public class StockSyncJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(StockSyncJob.class);

    @Autowired
    private SyncStockBo syncStockBo;
    @Autowired
    private EdbItemStockBo edbItemStockBo;
    @Autowired
    private ConfigService configService;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.info(LOGGER, "库存同步开始....");
        long startTime = System.currentTimeMillis();
        ErpManufacturerType erpType = configService.findErpSwitchesType();
        if(erpType == ErpManufacturerType.EDB){
            //e店宝商品库存同步
            edbItemStockBo.syncEdbStock();
        }else {
            //旺店通商品库存同步
            syncStockBo.syncStock();
        }
        long endTime = System.currentTimeMillis();
        AppLogUtil.info(LOGGER, "同步结束...本次同步耗时{}", endTime - startTime);
    }

}
