package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.SyncBlackListBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 黑名单同步任务，在每天凌晨3点执行，
 * 将静态库的策略黑名单导入到奇货业务库
 * Created by Messi on 2018/5/1.
 */
@Component
public class SyncBlackListJob extends AbstractQihoSimpleElasticJob  {

    private final static Logger LOGGER = LoggerFactory.getLogger(SyncBlackListJob.class);


    @Autowired
    private SyncBlackListBo syncBlackListBo;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("黑名单同步任务开始启动");
        syncBlackListBo.executeTask();
        LOGGER.info("黑名单同步任务执行完成");
    }
}
