package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.collect.Maps;
import com.qiho.center.biz.service.homepage.TabItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.entity.homepage.QihoTabItemEntity;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/8/30.
 */
@Component
public class TabItemSaleNumSyncJob extends AbstractQihoSimpleElasticJob{


	private static Logger logger = LoggerFactory.getLogger(TabItemSaleNumSyncJob.class);

	@Resource
	private TabItemService  tabItemService;

	@Resource
	private OrderSnapshotService orderSnapshotService;

	private int pageSize = 100;

	@Override
	protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {

		logger.warn("TabItemSaleNumSyncJob start");
		//分页处理相关数据
		int pageNum = 1;
		Map<Long,Integer> saleNumMap = Maps.newHashMap();
		Date startTime = DateUtils.getStartTime(DateUtils.daysAddOrSub(new Date(),-3));
		Date endTime = DateUtils.getStartTime(new Date());
		while (true) {
			List<QihoTabItemEntity> list = tabItemService.queryAllItemListByPage((pageNum-1)*pageSize,pageSize);
			if(CollectionUtils.isEmpty(list)){
					break;
			}
			for(QihoTabItemEntity entity : list){
				Integer saleNum =saleNumMap.get(entity.getItemId());
				if(null==saleNum){
					saleNum = orderSnapshotService.queryItemSaleCount(entity.getItemId(),startTime,endTime);
					saleNumMap.put(entity.getItemId(),saleNum);
				}
				entity.setRecentlySaleNum(saleNum);
				tabItemService.updateTabItem(entity);
			}
			pageNum ++;
		}

		logger.warn("TabItemSaleNumSyncJob success");
	}
}
