package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.MainItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.remoteservice.RemoteMainItemService;
import com.qiho.center.biz.service.MainItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2017/8/29.
 */
@RestController
public class RemoteMainItemServiceImpl implements RemoteMainItemService{

    private static Logger logger = LoggerFactory.getLogger(RemoteMainItemServiceImpl.class);

    @Resource
    MainItemService mainItemService;

    @Override
    public DubboResult<Integer> addMainItem(MainItemDto mainItemDto) {
        int result = 0;
        try{
            result = mainItemService.addMainItem(mainItemDto);
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.addMainItem failed, MainItemDto={}", mainItemDto, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<Integer> deleteMainItems(List<Long> ids) {
        int result = 0;
        try{
            result = mainItemService.deleteMainItems(ids);
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.deleteMainItems failed, ids={}", ids, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<Integer> editMainItem(MainItemDto mainItemDto) {
        int result=0;
        try {
            result = mainItemService.editMainItem(mainItemDto);
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.editMainItem failed, MainItemDto={}", mainItemDto, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<MainItemDto> queryMainItem(Long id) {
        MainItemDto mainItemDto = null;
        try {
            mainItemDto = mainItemService.queryMainItem(id);
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.queryMainItem failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(mainItemDto);
    }

    @Override
    public DubboResult<PagenationDto<MainItemDto>> queryMainItems() {
        PagenationDto<MainItemDto> pagenation = null;
        try{
            pagenation = mainItemService.queryMainItems();
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.queryMainItems failed", e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(pagenation);
    }

    @Override
    public DubboResult<PagenationDto<MainItemDto>> queryVaildList() {
        PagenationDto<MainItemDto> pagenation = null;
        try{
            pagenation = mainItemService.queryVaildList();
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.queryVaildList failed");
            return DubboResult.failResult(e.getMessage());
        }

        return DubboResult.successResult(pagenation);
    }

    @Override
    public DubboResult<Boolean> sortMainItem(Long mainIitemId, Integer originPayload, Integer newPayload) {
        try {
            mainItemService.sortMainItem(mainIitemId,originPayload,newPayload);
        }catch (Exception e){
            logger.error("invoke RemoteMainItemService.sortMainItem failed");
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(true);
    }

}
