/**
 * Project Name:qiho-center-biz
 * File Name:RemoteTemplateServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl
 * Date:2017年6月21日上午9:36:00
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.TemplateDto;
import com.qiho.center.api.remoteservice.RemoteTemplateService;
import com.qiho.center.biz.service.TemplateService;
import org.springframework.web.bind.annotation.RestController;


/**
 * ClassName:RemoteTemplateServiceImpl <br/>
 * 模板服务. <br/>
 * Date:     2017年6月21日 上午9:36:00 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@RestController
public class RemoteTemplateServiceImpl implements RemoteTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTemplateServiceImpl.class);
    
    @Autowired
    private TemplateService templateService;
    
    @Override
    public DubboResult<Void> enableSwitch(Long id, Boolean enable) {
        try {
            templateService.enableSwitch(id, enable);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.switchTemplate failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteTemplateService#addTemplate(java.lang.String, java.lang.String, java.lang.String)
     */
    @Override
    public DubboResult<Void> addTemplate(String templateCode, String templateName, String templateContext,String noteTemplateId,String smsType) {
        try {
            templateService.addTemplate(templateCode, templateName, templateContext,noteTemplateId,smsType);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.addTemplate failed, templateName={}", templateName, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteTemplateService#updateTemplate(java.lang.Long, java.lang.String)
     */
    @Override
    public DubboResult<Void> updateTemplate(Long id, String templateContext,String noteTemplateId,String smsType) {
        try {
            templateService.updateTemplate(id, templateContext,noteTemplateId,smsType);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.updateTemplate failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteTemplateService#findTemplateList()
     */
    @Override
    public DubboResult<List<TemplateDto>> findTemplateList() {
        try {
            List<TemplateDto> list = templateService.findTemplateList();
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.updateTemplate failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public TemplateDto findByCode(String templateCode) {
        try {
            return templateService.findByCode(templateCode);
        } catch (Exception e) {
            LOG.error("invoke RemoteTemplateService.updateTemplate failed", e);
            return new TemplateDto();
        }
    }

}

