package com.qiho.center.biz.remoteservice.impl.abtest;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.api.remoteservice.abtest.RemoteTestMetadataService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by qianjue on 2017/10/10.
 */
@RestController
public class RemoteTestMetadataServiceImpl implements RemoteTestMetadataService {

	@Resource
	private TestMetadataService  testMetadataService;

	@Override
	public int saveTestMetadata(TestMetadataDto dto) throws BizException {
		return testMetadataService.saveMetadata(dto);
	}

	@Override
	public int updateTestMetadata(TestMetadataDto dto) throws BizException {
		return testMetadataService.updateMetadata(dto);
	}

	@Override
	public TestMetadataDto selectById(Long id) {
		return testMetadataService.selectById(id);
	}

	@Override
	public List<TestMetadataDto> selectListByItemIdAndType(Long itemId, String metadataType) {
		return testMetadataService.selectListByTypeAndItemId(itemId,metadataType);
	}

	@Override
	public PagenationDto<TestMetadataDto> queryListByPage(TestMetadataQueryParam param) throws BizException {
		return testMetadataService.queryListByPage(param);
	}

	@Override
	public int deleteTestMetadata(Long id) throws BizException {
		return testMetadataService.deleteMetadata(id);
	}

	@Override
	public boolean syncToItemInfo(Long id,Long modifyId) throws BizException {
		return testMetadataService.syncToItemInfo(id,modifyId);
	}
}
