package com.qiho.center.biz.remoteservice.impl.account;

import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.remoteservice.account.RemoteBaiqiAccountService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.common.entityd.qiho.account.BaiqiAccountEntity;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by sunchangji on 2017/12/7.
 */
@RestController
public class RemoteBaiqiAccountServiceImpl implements RemoteBaiqiAccountService {
    @Resource
    private BaiqiAccountService baiqiAccountService;

    @Override
    public BaiqiAccountDto findByAccount(String account) {
        return baiqiAccountService.findByAccount(account);
    }

    @Override
    public BaiqiAccountDto findByMobile(String mobile) {
        return baiqiAccountService.findByMobile(mobile);
    }

    @Override
    public String findAccountById(Long id) {
        return baiqiAccountService.findAccountById(id);
    }

    @Override
    public Boolean updatePwd(Long id, String newPwd) {
        BaiqiAccountEntity accountEntity = new BaiqiAccountEntity();
        accountEntity.setId(id);
        accountEntity.setPwd(newPwd);

        return baiqiAccountService.update(accountEntity);
    }

    @Override
    public BaiqiAccountDto findById(Long id) {
        return baiqiAccountService.findById(id);
    }

    @Override
    public BaiqiAccountDto findMainAccountByMerchantId(Long merchantId) {
        BaiqiAccountEntity accountEntity = baiqiAccountService.findMainAccountByMerchantId(merchantId);
        return BeanUtils.copy(accountEntity, BaiqiAccountDto.class);
    }

    @Override
    public BaiqiAccountDto findByTypeAndRelationId(Integer accountType, Long relationId) {
        BaiqiAccountEntity accountEntity = baiqiAccountService.findByTypeAndRelationId(accountType, relationId);
        return BeanUtils.copy(accountEntity, BaiqiAccountDto.class);
    }
}
