package com.qiho.center.biz.remoteservice.impl.area;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.area.AddressDto;
import com.qiho.center.api.remoteservice.area.RemoteAddressService;
import com.qiho.center.biz.service.area.AddressService;

/**
 * @author chensong
 * @create 2018-01-26 11:50
 **/
@RestController
public class RemoteAddressServiceImpl implements RemoteAddressService {

    @Autowired
    private AddressService addressService;

    @Override
    public AddressDto findById(Long addressId) {
        return addressService.findById(addressId);
    }

    @Override
    public Boolean createAddress(AddressDto dto) {
        return addressService.createAddress(dto);
    }

    @Override
    public List<AddressDto> findByUserId(Long userId) {
        return addressService.findByUserId(userId);
    }

    @Override
    public Boolean deleteAddress(AddressDto dto) {
        return addressService.deleteAddress(dto);
    }

    @Override
    public Boolean alterDefault(AddressDto dto) {
        return addressService.alterDefault(dto);
    }

    @Override
    public Boolean updateAddress(AddressDto dto) {
        return addressService.updateAddress(dto);
    }

    @Override
    public AddressDto findByDefaultOrNew(Long userId) {
        return addressService.findByDefaultOrNew(userId);
    }

    @Override
    public AddressDto findByIdAndUserId(AddressDto dto) {
        return addressService.findByIdAndUserId(dto);
    }


}
