package com.qiho.center.biz.remoteservice.impl.blackList;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.params.blacklist.BlackListBatchDealParam;
import com.qiho.center.api.remoteservice.blackList.RemoteBaiqiBlackListService;
import com.qiho.center.biz.bo.SyncBlackListBo;
import com.qiho.center.biz.service.blacklist.BaiqiBlackListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-04-27 15:17
 **/
@RestController
public class RemoteBaiqiBlackListServiceImpl implements RemoteBaiqiBlackListService {

    @Autowired
    private BaiqiBlackListService baiqiBlackListService;

    @Autowired
    private SyncBlackListBo syncBlackListBo;


    @Override
    public PagenationDto<BaiqiBlackListDto> queryBlackListPage(BaiqiBlackListQueryParam param) {
        return baiqiBlackListService.queryPage(param);
    }

    @Override
    public ResultDto<Boolean> deleteBlackList(String name, Long id) {
        return baiqiBlackListService.deleteBlackList(id, name);
    }

    @Override
    public int queryBlackListPageCount(BaiqiBlackListQueryParam param) {
        return baiqiBlackListService.queryPageCount(param);
    }

    @Override
    public int batchAddBlackList(String cacheKey, List<BlackListBatchDealParam> list, Long merchantId, String operator) {
        return baiqiBlackListService.batchAddBlackList(cacheKey,list,merchantId,operator);
    }


}
