package com.qiho.center.biz.remoteservice.impl.homepage;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.api.remoteservice.homepage.RemoteTabItemService;
import com.qiho.center.biz.service.homepage.TabItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by qianjue on 2017/8/29.
 */
@RestController
public class RemoteTabItemServiceImpl implements RemoteTabItemService{

	private  static Logger logger  = LoggerFactory.getLogger(RemoteTabItemServiceImpl.class);

	@Resource
	private TabItemService  tabItemService;

	@Override
	public DubboResult<Integer> saveTabItemList(List<TabItemParams> list) {
		try{
			return  DubboResult.successResult(tabItemService.saveTabItemList(list));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call saveTabItemList error",e);
			return  DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> deleteTabItemByIdList(List<Long> idList) {
		try{
			return  DubboResult.successResult(tabItemService.deleteTabItemByIdList(idList));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call deleteTabItemByIdList error",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> updateTabItemTopPayloadByList(List<Long> idList, Long tabId, Boolean top) {
		try{
			return  DubboResult.successResult(tabItemService.updateTabItemTopPayloadByList(idList,tabId,top));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call updateTableTopPayloadByList error",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<TabItemDto>> findTabItemList(TabItemQueryParam params) {
		try{
			return  DubboResult.successResult(tabItemService.findTabItemList(params));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call findTabItemList error",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<ItemDto>> queryTabItemIndex(TabItemQueryParam params) {
		try{
			return  DubboResult.successResult(tabItemService.queryTabItemIndex(params));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call findTabItemList error",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Void> updateStatus(List<Long> itemIds, Long tabId, Integer status, Long gmtModifier) {
		try {
			tabItemService.updateStatus(itemIds, tabId, status, gmtModifier);
			return DubboResult.successResult(null);
		} catch (Exception e) {
			logger.error("invoke RemoteTabItemService.updateStatus failed, itemIds={}, tabId={}, status={}", itemIds, tabId, status, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public List<TabItemDto> queryTabItemByTabIdAndItemIds(List<Long> itemIdList, Long tabId) {
		return tabItemService.queryTabItemByTabIdAndItemIds(itemIdList, tabId);
	}

	@Override
	public DubboResult<Integer> saveTabItem(TabItemParams params) {
		try{
			return  DubboResult.successResult(tabItemService.saveTabItem(params));
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call saveTabItem error",e);
			return  DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> initTabItemStatus() {
		try{
			return  DubboResult.successResult(tabItemService.initTabItemStatus());
		}catch(Exception e){
			logger.error("RemoteTabItemServiceImpl call saveTabItem error",e);
			return  DubboResult.failResult(e.getMessage());
		}
	}
}
