package com.qiho.center.biz.remoteservice.impl.logistics;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.center.api.remoteservice.logistics.RemoteLogisticsService;
import com.qiho.center.biz.service.logistics.LogisticsService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2017-12-28 16:42
 **/
@RestController
public class RemoteLogisticsServiceImpl implements RemoteLogisticsService {

    @Autowired
    private LogisticsService logisticsService;

    @Override
    public List<LogisticsDto> findAll() {
        return BeanUtils.copyList(logisticsService.findAllByCache(), LogisticsDto.class);
    }

    @Override
    public PagenationDto<LogisticsDto> queryPage(LogisticsQueryParam param) {
        return logisticsService.queryPage(param);
    }

    @Override
    public List<LogisticsNicknameDto> findNickname(Long logisticsId) {
        return logisticsService.findNickname(logisticsId);
    }

    @Override
    public Boolean addNickname(LogisticsNicknameDto dto) throws BizException {
        return logisticsService.addNickname(dto);
    }

    @Override
    public Boolean deleteNickname(Long logisticsId) throws BizException {
        return logisticsService.deleteNickname(logisticsId);
    }

    @Override
    public LogisticsDto findByCode(String logisticsCode) {
        return BeanUtils.copy(logisticsService.findByCode(logisticsCode), LogisticsDto.class);
    }

    @Override
    public Boolean insertLogistics(LogisticsDto dto) {
        return logisticsService.insertLogistics(dto);
    }

    @Override
    public Boolean deleteLogistics(Long id) {
        return logisticsService.deleteLogistics(id);
    }

}
