package com.qiho.center.biz.remoteservice.impl.message;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageCheckedDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageCheckedPagingParams;
import com.qiho.center.api.remoteservice.message.RemoteMessageService;
import com.qiho.center.biz.service.message.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author: wangjin
 * @create 2018-07-02 15:15
 **/
@RestController
public class RemoteMessageServiceImpl implements RemoteMessageService {

    @Autowired
    private MessageService messageService;

    @Override
    public int countCheckedMessage(Long merchantId) {
        return messageService.countCheckedMessage(merchantId);
    }

    @Override
    public PagenationDto<MessageCheckedDto> findCheckedMessages(MessageCheckedPagingParams params) {
        return messageService.findCheckedMessages(params);
    }

    @Override
    public MessageNotifyDto findMessageById(Long id, Long merchantId) {
        return messageService.readMessage(id,merchantId);
    }

    @Override
    public MessageNotifyDto findMessageDescription(Long merchantId) {
        return messageService.findMessageDescription(merchantId);
    }
}
