package com.qiho.center.biz.remoteservice.impl.monitor;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteLogisticsMonitorPlanService;
import com.qiho.center.biz.service.monitor.LogisticsMonitorPlanService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/11/1.
 */
@RestController
public class RemoteLogisticsMonitorPlanServiceImpl implements RemoteLogisticsMonitorPlanService {

	@Resource
	private LogisticsMonitorPlanService     logisticsMonitorPlanService;

	@Override
	public int createMonitorPlan(LogisticsMonitorPlanDto dto) throws BizException {
		return logisticsMonitorPlanService.saveLogistMonitorPlan(dto);
	}

	@Override
	public PagenationDto<LogisticsMonitorPlanDto> queryPageList(MonitorPlanQueryParam queryParam) {
		return logisticsMonitorPlanService.queryPageList(queryParam);
	}

	@Override
	public LogisticsMonitorPlanDto selectDetailById(Long id) {
		return logisticsMonitorPlanService.getLogisticsMonitorPlanById(id);
	}

	@Override
	public int deleteMonitorPlan(Long id) {
		return logisticsMonitorPlanService.deleteMonitorPlan(id);
	}
}
