package com.qiho.center.biz.remoteservice.impl.order;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.params.DeliveryRecordQueryParams;
import com.qiho.center.api.remoteservice.order.RemoteDeliveryRecordService;
import com.qiho.center.biz.job.OrderFileDeliveryJob;
import com.qiho.center.biz.service.order.DeliveryRecordService;

import cn.com.duiba.boot.exception.BizException;

/**
 * @author jiafeng.geng
 * @create 2018-03-08 16:09:11
 **/
@RestController
public class RemoteDeliveryRecordServiceImpl implements RemoteDeliveryRecordService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDeliveryRecordServiceImpl.class);

    @Autowired
    private OrderFileDeliveryJob orderFileDeliveryJob;

    @Autowired
    private DeliveryRecordService deliveryRecordService;

    @Override
    public Boolean insertDeliveryRecord(DeliveryRecordDto dto) throws BizException {
        return deliveryRecordService.insertDeliveryRecord(dto);
    }

    @Override
    public PagenationDto<DeliveryRecordDto> deliveryRecordPageQuery(DeliveryRecordQueryParams params) {
        return deliveryRecordService.deliveryRecordPageQuery(params);
    }

    @Override
    public int findTodayCount(Long merchantId) {
        return deliveryRecordService.findTodayCount(merchantId);
    }

    @Override
    public void doOrderFileDeliveryJob() {
        try {
            orderFileDeliveryJob.doStart();
        } catch (Exception e) {
            LOGGER.error("执行任务错误", e);
        }
    }
}
