package com.qiho.center.biz.remoteservice.impl.page;

import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.center.api.params.CollItemListQueryParam;
import com.qiho.center.api.remoteservice.page.RemoteCollPageBackendService;
import com.qiho.center.biz.service.page.BaiqiPageService;
import com.qiho.center.biz.service.page.CollPageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
@RestController
public class RemoteCollPageBackendServiceImpl implements RemoteCollPageBackendService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCollPageBackendServiceImpl.class);

    @Resource
    private CollPageService collPageService;

    @Resource
    private BaiqiPageService baiqiPageService;

    @Override
    public List<CollPageDto> queryList() {
        List<CollPageDto> collPageDtoList = null;
        try {
            collPageDtoList = collPageService.queryList();
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollPageBackendService.queryList failed", e);
        }
        return collPageDtoList;
    }

    @Override
    public List<BaiqiPageDto> querySkinList(Integer pageType) {
        List<BaiqiPageDto> baiqiPageDtoList = null;
        try {
            baiqiPageDtoList = baiqiPageService.findAll(pageType);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollPageBackendService.querySkinList failed, pageType={}", pageType, e);
        }
        return baiqiPageDtoList;
    }

    @Override
    public Integer addCollPage(CollPageDto collPageDto) {
        Integer result = null;
        try {
            result = collPageService.addCollPage(collPageDto);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollPageBackendService.addCollPage failed, collPageDto={}", collPageDto, e);
        }
        return result;
    }

    @Override
    public Integer updateCollPage(CollPageDto collPageDto) {
        Integer result = null;
        try {
            result = collPageService.updateCollPage(collPageDto);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollPageBackendService.updateCollPage failed, collPageDto={}", collPageDto, e);
        }
        return result;
    }

    @Override
    public List<ItemDto> queryCollItemIndex(CollItemListQueryParam params) {
        List<ItemDto> itemDtoList = null;
        try {
            itemDtoList = collPageService.queryCollItemIndex(params);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollPageBackendService.queryCollItemIndex failed, params={}", params, e);
        }
        return itemDtoList;
    }
}
