package com.qiho.center.biz.remoteservice.impl.tag;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagService;
import com.qiho.center.biz.service.tag.ItemTagService;
import com.qiho.center.biz.service.tag.TagService;

/**
 * @author chensong
 * @create 2018-03-23 09:48
 **/
@RestController
public class RemoteTagServiceImpl implements RemoteTagService{

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteTagServiceImpl.class);

    @Autowired
    private TagService tagService;

    @Autowired
    private ItemTagService itemTagService;


    @Override
    public ResultDto<Boolean> saveTag(TagDto tagDto) {
        return tagService.saveTag(tagDto);
    }

    @Override
    public Boolean delete(Long tagId) {
        return tagService.delete(tagId);
    }

    @Override
    public List<TagDto> findByTypeId(Long typeId) {
        return tagService.findByTypeId(typeId);
    }

    @Override
    public PagenationDto<TagDto> queryPage(TagPageParam param) {
        return tagService.queryPage(param);
    }

    @Override
    public List<TagDto> findByItemId(Long itemId) {
        return itemTagService.findByItemId(itemId);
    }

    @Override
    public ResultDto<Boolean> saveItemTag(Long itemId, List<Long> tagIds) {
        return itemTagService.saveItemTag(itemId, tagIds);
    }

    @Override
    public Boolean deleteByItemIdList(List<Long> itemIdList) {
        return itemTagService.batchDeleteByItemId(itemIdList);
    }

    @Override
    public List<TagDto> findByItemIds(List<Long> itemIdList) {
        List<TagDto> tagDtoList = null;
        try {
            tagDtoList = itemTagService.findByItemIds(itemIdList);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteTagService.findByItemIds failed, itemIdList={}", itemIdList, e);
        }
        return tagDtoList;
    }
}
