package com.qiho.center.biz.remoteservice.impl.tag;

import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.center.api.params.tag.QueryTagTypeParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagTypeService;
import com.qiho.center.biz.service.tag.TagTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-03-23 09:48
 **/
@RestController
public class RemoteTagTypeServiceImpl implements RemoteTagTypeService {

    @Autowired
    private TagTypeService tagTypeService;


    @Override
    public ResultDto<Boolean> saveTagType(TagTypeDto tagTypeDto, List<Long> categoryIds) {
        return tagTypeService.saveTagType(tagTypeDto, categoryIds);
    }

    @Override
    public List<TagTypeDto> queryTagType(QueryTagTypeParam param) {
        return tagTypeService.queryTagType(param);
    }

    @Override
    public Boolean deleteTagType(Long typeId) {
        return tagTypeService.deleteTagType(typeId);
    }

    @Override
    public ResultDto<List<TagTypeDto>> findByItemId(Long itemId) {
        return tagTypeService.findByItemId(itemId);
    }

    @Override
    public List<CategoryDto> findCategoryByTypeId(Long typeId) {
        return tagTypeService.findCategoryByTypeId(typeId);
    }
}
