package com.qiho.center.biz.remoteservice.impl.user;

import java.util.List;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.user.UserEvaluateDto;
import com.qiho.center.api.params.user.UserEvaluatePagingParams;
import com.qiho.center.api.remoteservice.user.RemoteUserEvaluateService;
import com.qiho.center.biz.service.user.UserEvaluateService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 用户评价
 * @author: wangjin
 * @create 2018-05-23 15:03
 **/
@RestController
public class RemoteUserEvaluateServiceImpl implements RemoteUserEvaluateService {

    @Resource
    private UserEvaluateService userEvaluateService;

    @Override
    public int insertUserEvaluate(UserEvaluateDto record) {
        return userEvaluateService.insert(record);
    }

    @Override
    public int selectUserEvaluateCount(String orderId) {
        return userEvaluateService.selectUserEvaluateCount(orderId);
    }

    @Override
    public UserEvaluateDto selectLatestUserEvaluate(String orderId) {
        return userEvaluateService.selectLatestUserEvaluate(orderId);
    }

    @Override
    public PagenationDto<UserEvaluateDto> findPaing(UserEvaluatePagingParams pagingParams) {
        return userEvaluateService.findPaging(pagingParams);
    }

    @Override
    public List<UserEvaluateDto> findEvaluateList(UserEvaluatePagingParams pagingParams) {
        return userEvaluateService.findEvaluateList(pagingParams);
    }
}
