package com.qiho.center.biz.remoteservice.impl.warning;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.warning.StockWarningDto;
import com.qiho.center.api.params.warning.StockWarningParams;
import com.qiho.center.api.remoteservice.warning.RemoteStockWarningService;
import com.qiho.center.biz.service.warning.StockWarningService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.dao.QihoOrderItemInfoDAO;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by weny.cai on 2018/1/15.
 */
@RestController
public class RemoteStockWarningServiceImpl implements RemoteStockWarningService{

    @Resource
    StockWarningService stockWarningService;

    @Resource
    private QihoOrderItemInfoDAO qihoOrderItemInfoDAO;

    @Resource
    private QihoItemSkuDAO qihoItemSkuDAO;

    @Resource
    private RemoteStockService remoteStockService;

    @Override
    public PagenationDto<StockWarningDto> queryByParam(StockWarningParams params) {
        return stockWarningService.queryByParam(params);
    }

    @Override
    public ItemSkuDto queryByOrderId(String orderId) {
        QihoItemSkuEntity itemSkuEntity = qihoItemSkuDAO.findById(qihoOrderItemInfoDAO.findByOrderId(orderId).getSkuId());
        return BeanUtils.copy(itemSkuEntity, ItemSkuDto.class);
    }

    @Override
    public Long queryByStockId(Long stockId) {
        return remoteStockService.find(stockId).getResult();
    }
}
