package com.qiho.center.biz.remoteservice.impl.wechat;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.config.WechatItemConfigDto;
import com.qiho.center.api.remoteservice.wechat.RemoteWechatItemService;
import com.qiho.center.biz.service.wechat.WechatItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chensong
 * @create 2018-09-05
 */
@RestController
public class RemoteWechatItemServiceImpl implements RemoteWechatItemService {

    @Autowired
    private WechatItemService wechatItemService;

    @Override
    public WechatItemConfigDto getWechatItemConfig(Long itemId) {
        return wechatItemService.getWechatItemConfig(itemId);
    }

    @Override
    public ResultDto<Boolean> saveWechatItemConfig(Long itemId, WechatItemConfigDto itemConfig) {
        return wechatItemService.saveWechatItemConfig(itemId, itemConfig);
    }


}
