package com.qiho.center.biz.runnable;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.collect.Lists;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.biz.service.BlackListService;

@Component
@Scope("prototype")
public class BlackListRunnable implements Runnable {

    private Logger                                      logger            = LoggerFactory.getLogger(BlackListRunnable.class);

    @Autowired
    private BlackListService                            blackListService;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate                         redisTemplate;

    private List<BlackListOperationParams>              params         = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;

    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (BlackListOperationParams param : params) {
                try {
                    Integer result = 0;
                    if (param.getDataType() == BlackListOperationParams.ADD_TYPE) {
                        BlackListParams blackListParams = BeanUtils.copy(param, BlackListParams.class);
                        Integer count = blackListService.findBlackListCount(blackListParams);
                        if (count > 0) {
                            failCount++;
                            continue;
                        }
                        result = blackListService.addBlackValue(param);
                    } else if (param.getDataType() == BlackListOperationParams.DELETE_TYPE) {
                        result = blackListService.deleteByValue(param);
                    }
                    if (result != 1) {
                        failCount++;
                    }
                } catch (Exception e) {
                    failCount++;
                    logger.error("物流订单签收批量失败", e);
                } finally {
                    ops.increment("successCount", 1L);
                }
            }
        } finally {
            ops.increment("failCount", failCount);
            ops.increment("taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParams(List<BlackListOperationParams> params) {
        this.params.addAll(params);
    }

    /**
     * @return
     */
    public Integer enableFilter() {
        List<BlackListOperationParams> newList = Lists.newArrayList();
        for (BlackListOperationParams param : this.params) {
            if (StringUtils.isBlank(param.getBkValue())) {
                continue;
            }
            newList.add(param);
        }
        params.clear();
        params.addAll(newList);
        return newList.size();
    }
}
