package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.common.constant.DsConstants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/6/14.
 */
@Component
@Scope("prototype")
public class DealWithErpOrderDeliverRunnable implements Runnable {

    private Logger logger = LoggerFactory.getLogger(DealWithErpOrderDeliverRunnable.class);

    @Autowired
    private ErpOrderBo erpOrderBo;

    @Autowired
    private ErpOrderService erpOrderService;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    private List<BatchResolveErpDeliverParams> paramsList = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;

    public Integer init() {
        return paramsList.size();
    }

    @Override
    public void run() {
        long failCount = 0L;
        Set<String> failErpIdSet = new HashSet<>();
        Set<Integer> failRowSet = new HashSet<>();  //用于记录失败的第几行数
        try {
            int index = 0;
            for (BatchResolveErpDeliverParams param : paramsList) {
                index++;
                try {
                    switch (param.getDealResult()) {
                    case BatchResolveErpDeliverParams.DEAL_RESULT_SUCCESS:
                        resolveDeliver(param);
                        break;
                    case BatchResolveErpDeliverParams.DEAL_RESULT_FAILD:
                        rejectDeliver(param);
                        break;
                    default:
                        break;
                    }
                } catch (Exception e) {
                    failCount++;
                    failErpIdSet.add(param.getErpId());//处理失败的子订单id
                    failRowSet.add(index);
                } finally {
                    ops.increment("successCount", 1L);
                }
            }
        } finally {
            ops.increment("failCount", failCount);
            ops.increment("taskCount", -1L);
            setFailErpIdsToredis(failErpIdSet);
            setFailRow(failRowSet);
        }
    }

    /**
     * 设置失败erpId
     *
     * @param failErpIdSet
     */
    private void setFailErpIdsToredis(Set<String> failErpIdSet) {
        if (failErpIdSet.isEmpty()) {
            return;
        }
        String failErpIds = StringUtils.join(failErpIdSet, ",");
        String exFailErpIds = ops.get(DsConstants.FAILIDS).toString();
        if (StringUtils.isBlank(exFailErpIds)) {
            ops.put(DsConstants.FAILIDS, failErpIds);
        } else {
            ops.put(DsConstants.FAILIDS, exFailErpIds + "," + failErpIds);
        }
    }

    private void setFailRow(Set<Integer> set) {
        if (set.isEmpty()) {
            return;
        }
        String failRows = StringUtils.join(set, ",");
        ops.put("failMsg", failRows);
    }

    private void resolveDeliver(BatchResolveErpDeliverParams params) {
        ResolveDeliverParams pp = new ResolveDeliverParams();
        pp.setBaiqiLogisticsName(params.getBaiqiLogisticsName());
        pp.setBaiqiLogisticsCode(params.getBaiqiLogisticsCode());
        pp.setExpressCode(params.getExpressCode());
        pp.setErpId(params.getErpId());
        erpOrderBo.resolveDeliver(pp);
    }

    private void rejectDeliver(BatchResolveErpDeliverParams params) {
        erpOrderBo.cancelDeliver(params.getErpId());
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParamsList(List<BatchResolveErpDeliverParams> paramsList) {
        this.paramsList.addAll(paramsList);
    }
}
