package com.qiho.center.biz.runnable;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.biz.service.BlackListService;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by danke on 2017/7/19.
 */
@Component
@Scope("prototype")
public class ExpressBlackListRunnable implements Runnable {

    private Logger log            = LoggerFactory.getLogger(ExpressBlackListRunnable.class);

    @Autowired
    private BlackListService blackListService;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    private List<ExpressBlackListOperationParams> params         = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;
    
    private static Map<ExpressCompanyEnum,QueryBlackListTypeEnum> map = Maps.newHashMap();
    
    static{
    	map.put(ExpressCompanyEnum.YTO, QueryBlackListTypeEnum.EXPRESS_COMPANY);
    	map.put(ExpressCompanyEnum.YTO_PAID, QueryBlackListTypeEnum.EXPRESS_COMPANY_PUTO);
    }
    
    @Override
    public void run() {
		// 处理对应的逻辑
		int failCount = 0;
		for (ExpressBlackListOperationParams param : params) {
			int result = 0;
			try {
				// 新增
				if (param.getDataType() == ExpressBlackListOperationParams.ADD_TYPE) {
					// 校验数据,类型不存在
					if (null == param.getCompanyEnum()) {
						failCount++;
						continue;
					}
					// 查询一下值对不对
					Long recordId = blackListService.findOneBlack(param.getCompanyEnum(), param.getBkValue());
					if (null == recordId) {
						// 插入新数据
						BlackListOperationParams para = BeanUtils.copy(param,BlackListOperationParams.class);
						para.setType(map.get(param.getCompanyEnum()));
						result = blackListService.addBlackValue(para);
					}
					// 删除
				} else if (param.getDataType() == ExpressBlackListOperationParams.DELETE_TYPE) {
					BlackListOperationParams para = BeanUtils.copy(param,BlackListOperationParams.class);
					para.setType(map.get(param.getCompanyEnum()));
					result = blackListService.deleteByValue(para);
				}
				if (result == 0) {
					failCount++;
				}
			} catch (Exception e) {
				failCount++;
				log.error("ExpressBlackListRunnable run error,param =>{},error=>{}",JSON.toJSONString(param), e.getMessage());
			} finally {
				ops.increment("successCount", 1);
			}
		}
		ops.increment("failCount", failCount);
		ops.increment("taskCount", -1L);
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParams(List<ExpressBlackListOperationParams> params) {
        this.params = params;
    }

    /**
     * @return
     */
    public Integer enableFilter() {
        List<ExpressBlackListOperationParams> newList = Lists.newArrayList();
        for (ExpressBlackListOperationParams param : this.params) {
            if (StringUtils.isBlank(param.getBkValue())) {
                continue;
            }
            newList.add(param);
        }
        params.clear();
        params.addAll(newList);
        return newList.size();
    }
}
