package com.qiho.center.biz.service;

import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.dto.blackList.BlacklistCheckDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.BlackListCheckParams;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.biz.service.blacklist.BaiqiBlackListService;

import java.util.Date;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/22.
 * 快递黑名单服务
 *
 * 该黑名单服务已废弃 新的黑名单服务请使用{@link BaiqiBlackListService}
 */
@Deprecated
public interface BlackListService {

    /**
     * 分页查询快递黑名单
     * @param params
     * @return
     */
    PagenationDto<ExpressBlackListDto> findExpressBlackPage(ExpressBlackListPageParams params);

    /**
     * 验证单个黑名单的存在
     * @param expressCompany
     * @param addressCode
     * @return 存在返回id,不存在返回为空
     */
    Long findOneBlack(ExpressCompanyEnum expressCompany, String addressCode);

    /**
     * 根据id删除
     * @param id
     * @param type 
     * @return
     */
    Boolean deleteById(Long id, QueryBlackListTypeEnum type);
    
    /**
     * 根据黑名单的值删除
     * @param id
     * @param type 
     * @return
     */
    Integer deleteByValue(BlackListOperationParams params);

    /**
     * 批量添加收货黑名单地址
     * @param expressCompany
     * @param addressCodes
     * @return
     */
    Integer batchAddExpressBlackList(ExpressCompanyEnum expressCompany, Set<String> addressCodes);

    /**
     * 分页查询黑名单（手机号，地域）
     *
     * @author chencheng
     * @param params
     * @return
     */
    PagenationDto<BlackListDto> queryBlackListPage(BlackListParams params);

    /**
     * 
     * 新增黑名单的值
     *
     * @author chencheng
     * @param param
     * @return
     */
    Integer addBlackValue(BlackListOperationParams params);

    /**
     * 查询黑名单总数
     *
     * @author chencheng
     * @param params
     * @return
     */
    Integer findBlackListCount(BlackListParams params);

    /**
     * 查询单个黑名单(一般用于验证黑名单的存在)
     * @param type
     * @param bkValue
     * @return
     */
    BlackListDto findOneBlacklist(QueryBlackListTypeEnum type, String bkValue);


    /**
     * 策略黑名单验证
     * @param type
     * @param bkValue
     * @param curDate
     * @return
     */
    BlackListDto findOneBlacklist(QueryBlackListTypeEnum type,String bkValue ,Date curDate);

    /**
     * 根据类型获取bi回流数据最新时间
     */
    BlackListDto findLatestDateByType(QueryBlackListTypeEnum type);

    /**
     * 黑名单通用校验
     * @author zhanglihui
     * @param params
     * @return
     */
    BlacklistCheckDto blacklistCheck(BlackListCheckParams params);

	/**
     * 根据条件查询总数
     * @param params
     * @return
     */
    Integer findExpressBlackNum(ExpressBlackListPageParams params);
}
