/**
 * Project Name:qiho-center-biz
 * File Name:SkuPropertyService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月20日下午3:44:01
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import com.qiho.center.api.dto.SkuPropertyDto;
import com.qiho.center.api.dto.SkuPropertyValueDto;

import java.util.List;
import java.util.Map;

/**
 * ClassName:SkuPropertyService <br/>
 * Date:     2017年5月20日 下午3:44:01 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface SkuPropertyService {

    /**
     * 根据itemId查询商品属性
     * @author zhanglihui
     * @param itemId
     * @return List<SkuPropertyDto>
     */
    List<SkuPropertyDto> getSkuPropertyByItemId(Long itemId);

    /**
     *
     * @author zhanglihui
     * @param propertyList
     * @param itemId
     */
    void updateItemId(List<SkuPropertyDto> propertyList, Long itemId);

    /**
     * 批量保存属性名
     * @author zhanglihui
     * @param propertyNames
     * @return 返回id：属性名Map
     */
    Map<Long, String> createPropertyNames(List<String> propertyNames);

    /**
     * 批量保存属性值
     * @author zhanglihui
     * @param propertyValues 属性值列表
     * @return id：属性值Map
     */
    Map<Long, String> createPropertyValues(List<SkuPropertyValueDto> propertyValues);

    /**
     * 生效商品属性
     * @author zhanglihui
     * @param propertyList
     * @param itemId 
     */
    void enableProperty(List<SkuPropertyDto> propertyList, Long itemId);

    /**
     * 根据ID更新属性值
     *
     * @author zhanglihui
     * @param id
     * @param propertyValue
     */
    void updatePropertyValue(Long id, String propertyValue);

    /**
     * 根据ID更新属性名称
     *
     * @param id
     * @param propertyName
     * @author jiafeng.geng
     */
    void updatePropertyName(Long id, String propertyName);
}

