package com.qiho.center.biz.service.advert;

import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaAdvertConsumeEntity;

import java.util.Date;
import java.util.List;

/**
 * 推啊广告消耗service
 *
 * @author peanut.huang
 * @date 2017/12/27.
 */
public interface BaiqiTuiaAdvertConsumeService {

    /**
     * insert
     *
     * @param consumeEntity
     */
    void insert(BaiqiTuiaAdvertConsumeEntity consumeEntity);

    /**
     * 根据时间段或商家id查询广告消耗数据
     *
     * @param merchantId   商家id精准查询
     * @param startDate    时间日期起
     * @param endDate      时间日期止
     * @return
     */
    List<MerchantAdvertDto> findAdvertConsume(Long merchantId, Date startDate, Date endDate);
}
