package com.qiho.center.biz.service.advert.impl;

import com.qiho.center.biz.service.advert.BaiqiTuiaPlanService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.advert.BaiqiTuiaPlanMapper;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaPlanEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 广告计划service
 *
 * @author peanut.huang
 * @date 2018/1/4.
 */
@Service
public class BaiqiTuiaPlanServiceImpl implements BaiqiTuiaPlanService {

    @Resource
    private BaiqiTuiaPlanMapper baiqiTuiaPlanMapper;


    @Override
    @Transactional(rollbackFor = Exception.class, value = DsConstants.DATABASE_QIHO)
    public void batchInsert(List<BaiqiTuiaPlanEntity> insertList) {
        if(CollectionUtils.isEmpty(insertList)){
            return;
        }

        //过滤已存在的广告计划
        List<BaiqiTuiaPlanEntity> resultInsertList = filterExistPlan(insertList);
        if(CollectionUtils.isNotEmpty(resultInsertList)){
            //batch insert
            baiqiTuiaPlanMapper.batchInsert(resultInsertList);
        }
    }


    /**
     * filter exist plan
     *
     * @param insertList
     * @return
     */
    private List<BaiqiTuiaPlanEntity> filterExistPlan(List<BaiqiTuiaPlanEntity> insertList) {

        //find all
        List<BaiqiTuiaPlanEntity>  allPlanList = baiqiTuiaPlanMapper.findAll();

        if(CollectionUtils.isEmpty(allPlanList)){
            return insertList;
        }else {

            // exist plan ids
           List<Long>  existPlanIds = allPlanList.stream().map(BaiqiTuiaPlanEntity::getPlanId).collect(Collectors.toList());

            //filter
            return insertList.stream().filter(e -> !existPlanIds.contains(e.getPlanId())).collect(Collectors.toList());
        }
    }
}
