package com.qiho.center.biz.service.agent;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.AgentMerchantsDto;
import com.qiho.center.api.params.agent.AgentMerchantPageParams;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentMerchantRelationEntity;

import java.util.List;

/**
 * 代理商和商家关联关系service
 * Author: zhanghuifeng
 * Date:   19:15 2017/12/14
 */
public interface BaiqiAgentMerchantService {

	/**
	 * 查询已经关联的商家id集合
	 * @param agentId 代理商id
	 * @return 商家id集合
	 */
	List<Long> findExistMerchantIds(Long agentId);

	/**
	 * 批量插入
	 * @param list 数据
	 * @return boolean
	 */
	Boolean batchInsert(List<BaiqiAgentMerchantRelationEntity> list);

	/**
	 * 查询已经关联的商家id集合
	 * @return 商家id集合
	 */
	List<Long> findAllMerchantIds();

    /**
     * 查询商家是否在代理商下
     *
     * @param agentId    代理商id
     * @param merchantId 商家id
     * @return
     */
    Boolean findByAgentIdAndMerchantId(Long agentId, Long merchantId);

	/**
	 * 根据条件分页查询代理商下的商家列表信息
	 * @param pageParams
	 * @return
	 */
	PagenationDto<AgentMerchantsDto> findPageByAgentId(AgentMerchantPageParams pageParams);
}
