package com.qiho.center.biz.service.agent;

import java.util.List;
import java.util.Map;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;

/**
 * 代理商service
 * Author: zhanghuifeng
 * Date:   19:15 2017/12/14
 */
public interface BaiqiAgentService {


	Map<Long,BaiqiAgentEntity> findByIdsMap(List<Long> ids);


	/**
	 * 获取所有代理商数据
	 * @return 代理商集合
	 */
	List<BaiqiAgentEntity> findAll();

	/**
	 * 分页查询所有代理商信息
	 * @return 代理商
	 */
	PagenationDto<BaiqiAgentDto> find4Page(AgentPageParam params);

	/**
	 * 更新代理商
	 * @param agentDto 代理商数据
	 * @return boolean
	 */
	Boolean update(BaiqiAgentDto agentDto);

	/**
	 * 新增代理商
	 * @param agentEntity 数据
	 * @return boolean
	 */
	Boolean insert(BaiqiAgentEntity agentEntity);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    BaiqiAgentEntity findById(Long id);

	/**
	 * 获取所有简单代理商信息
	 * @return 集合
	 */
	List<SimpleIdAndNameDto> findSimpleAll();

	/**
	 * 根据商家id查询关联的代理商
	 * @param merchantId 商家id
	 * @return
	 */
	BaiqiAgentEntity findAgentByMerchantId(String merchantId);

	/**
	 * 根据代理商名称获取
	 * @param agentName
	 * @return
	 */
	BaiqiAgentDto findByAgentName(String agentName);

}
