package com.qiho.center.biz.service.area;

import java.util.List;

import com.qiho.center.api.dto.area.AddressDto;

/** 收货地址服务接口
 * @author chensong
 * @create 2018-01-25 11:44
 **/
public interface AddressService {

    /**
     * 获取用户列表 默认地址在最上面
     * @param userId
     * @return
     */
    List<AddressDto> findByUserId(Long userId);

    /**
     * 新增用户收货地址
     * @return
     */
    Boolean createAddress(AddressDto dto);

    /**
     * 删除收货地址
     * @return
     */
    Boolean deleteAddress(AddressDto dto);

    /**
     * 用户修改默认地址
     * @param dto
     * @return
     */
    Boolean alterDefault(AddressDto dto);

    /**
     * 更新地址
     * @param dto
     * @return
     */
    Boolean updateAddress(AddressDto dto);

    /**
     * 根据id获取收货地址信息
     * @param addressId
     * @return
     */
    AddressDto findById(Long addressId);

    /**
     * 查找默认的地址或最新的地址
     * @param userId
     * @return
     */
    AddressDto findByDefaultOrNew(Long userId);

    /**
     * 查找指定Id地址
     * @param dto
     * @return
     */
    AddressDto findByIdAndUserId(AddressDto dto);
}
