package com.qiho.center.biz.service.finance;

import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.enums.finance.PartnerResultStateEnum;
import com.qiho.center.biz.service.impl.finance.bean.PartnerAllocateAmountBean;

import cn.com.duiba.boot.exception.BizException;

/**
 * AllocateAmount
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-27 20:15
 */
public interface AllocateAmountService {

    /**
     * 调用外部（推啊）金额划拨接口
     *
     * @param bean
     * @return
     */
    PartnerResultStateEnum callPartnerAllocateAmount(PartnerAllocateAmountBean bean);

    /**
     * 调用外部（推啊）金额划拨检查
     *
     * @param baiqiTradeNo 百奇交易号
     * @return
     */
    PartnerResultStateEnum checkPartnerAllocateAmount(String baiqiTradeNo);

    /**
     * 金额分配(划拨)
     *
     * @param allocateAmountDto
     * @return
     */
    PartnerResultStateEnum allocateAmountRecharge(AllocateAmountDto allocateAmountDto) throws BizException;

    /**
     * 如果调用合作商接口超时或异常, 状态为:9 {@link com.qiho.center.api.enums.finance.FinanceDetailStatusEnum#num}
     * 定时任务，根据 finance_trade_no 重试查询合作商
     */
    void retryCallPartner();

    /**
     * 金额分配(回拨)
     *
     * @param allocateAmountDto
     * @return
     */
    PartnerResultStateEnum allocateAmountReverse(AllocateAmountDto allocateAmountDto) throws BizException;
}
