package com.qiho.center.biz.service.finance;

import java.util.Date;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;

/**
 * Created by xianhongwei on 2017/12/20.
 */
public interface FinanceDetailService {

    /**
     * 根据所给参数查询流水信息实体类
     */
    PagenationDto<FinanceDetailDto> findByParams(BaiqiMerchantFreetextParam params);

    /**
     * 插入流水信息实体类
     */
    Long insert(FinanceDetailDto entity);

    /**
     * 查询商家的
     * 财务流水信息
     */
    PagenationDto<FinanceDetailDto> findFinanceDetailByMerchantId(BaiqiMerchantFreetextParam pageParam);

    /**
     * 查询代理商的
     * 财务流水信息
     */
    PagenationDto<FinanceDetailDto> findFinanceDetailByAgentId(BaiqiMerchantFreetextParam pageParam);

    BaiqiFinanceDetailEntity findFinanceDetailByTradeNo(int relationType, String tradeNo);

    /**
     * 分页查询历史余额信息
     */
    PagenationDto<HistoricalBalanceDto> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam params);

    /**
     * 同步历史余额信息
     */
    Boolean historicalBalanceSync();

    /**
     * 查询财务流水信息的总条数
     *
     * @param
     * @param
     * @return
     */
    Integer findIncomeInfoCount();

    /**
     * 查询历史余额信息的总条数
     *
     * @param
     * @param
     * @return
     */
    Integer findHistoricalBalanceCount();

}
