package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.enums.BannerTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.BannerService;
import com.qiho.center.common.dao.QihoBannerDAO;
import com.qiho.center.common.entity.item.QihoBannerEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2017-08-28 17:57
 **/
@Service
public class BannerServiceImpl implements BannerService{

    @Autowired
    private QihoBannerDAO qihoBannerDAO;

    @Override
    public BannerDto findById(Long id) {
        QihoBannerEntity entity = qihoBannerDAO.findById(id);
        if (entity == null){
            return new BannerDto();
        }
        BannerDto banner = BeanUtils.copy(entity, BannerDto.class);
        banner.setBannerType(BannerTypeEnum.getByCode(entity.getBannerType()));
        return banner;
    }

    @Override
    public List<BannerDto> findAllBanners(String bannerType) {
        BannerTypeEnum bannerTypeEnum =BannerTypeEnum.getByCode(bannerType);
        if (bannerTypeEnum == null){
            throw new QihoException("传入的Banner类型错误");
        }
        List<QihoBannerEntity> entityList = qihoBannerDAO.findAllBanners(bannerType);
        if(CollectionUtils.isEmpty(entityList)){
            return Lists.newArrayList();
        }
        return listTransform(entityList,bannerTypeEnum);
    }

    @Override
    public List<BannerDto> findValidBanners(String bannerType) {
        BannerTypeEnum bannerTypeEnum =BannerTypeEnum.getByCode(bannerType);
        if (bannerTypeEnum == null){
            throw new QihoException("传入的Banner类型错误");
        }
        List<QihoBannerEntity> entityList = qihoBannerDAO.findValidBanners(bannerType);
        if(CollectionUtils.isEmpty(entityList)){
            return Lists.newArrayList();
        }
        return listTransform(entityList,bannerTypeEnum);
    }

    private List<BannerDto> listTransform(List<QihoBannerEntity> entityList, BannerTypeEnum bannerTypeEnum){
        return Lists.transform(entityList, entity ->{
            BannerDto dto = BeanUtils.copy(entity,BannerDto.class);
            dto.setBannerType(bannerTypeEnum);
            return dto;
        });
    }

    @Override
    public int saveBanner(BannerDto dto) {
        QihoBannerEntity entity = BeanUtils.copy(dto,QihoBannerEntity.class);
        entity.setBannerType(dto.getBannerType().getCode());
        int result;
        if (dto.getId() == null){
            result = qihoBannerDAO.createBanner(entity);
        } else {
            result = qihoBannerDAO.updateBanner(entity);
        }
        return result;
    }

    @Override
    public int deleteBanner(Long id) {
        return qihoBannerDAO.deleteBanner(id);
    }

    @Override
    public int sortBanner(String idList) {
        List<Long> ids = Arrays.asList(idList.split(",")).stream().map(s -> Long.parseLong(s.trim())).
                collect(Collectors.toList());
        if (ids.size() != qihoBannerDAO.countBanner(BannerTypeEnum.CAROUSEL.getCode())){
            throw new QihoException("传入Id数与Banner数不一致");
        }
        List<QihoBannerEntity> entityList = qihoBannerDAO.findAllBanners(BannerTypeEnum.CAROUSEL.getCode());
        int index = 0;
        for (Long id : ids){
            entityList.get(index).setId(id);
            entityList.get(index).setPayload(ids.size()-index);
            index++;
        }
        return qihoBannerDAO.updatePayloadBatch(entityList);
    }

    @Override
    public int countBanner(String bannerType) {
        return qihoBannerDAO.countBanner(bannerType);
    }

    @Override
    public int findMaxPayload() {
        Integer maxPayload = qihoBannerDAO.findMaxPayload();
        if (null == maxPayload){
            return 0;
        }
        return maxPayload;
    }


}
