package com.qiho.center.biz.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.qiho.center.biz.service.ItemDaySaleService;
import com.qiho.center.common.daoh.qihostatistics.QihoItemDaySaleMapper;

/**
 * Created by Zhangshun on 2018/4/3,11:57:01.
 */
@Service
public class ItemDaySaleServiceImpl implements ItemDaySaleService {

    @Resource
    private QihoItemDaySaleMapper qihoItemDaySaleMapper;

    @Override
    public Map<Long, Long> queryItemSaleCountBatch(List<Long> itemIdList, Date startTime, Date endTime) {

        Map<String, Object> params = Maps.newHashMap();
        params.put("itemIdList", itemIdList);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        Map<Long, Long> map = Maps.newHashMap();

        //现将所有的出事数量设置为0
        itemIdList.stream().forEach(itemId -> map.put(itemId, 0L));

        List<Map<String, Object>> maps = qihoItemDaySaleMapper.countByParam(params);

        maps.stream().forEach(e -> {
            Long itemId = null;
            Long saleNum = 0L;
            for (Map.Entry<String, Object> ma : e.entrySet()) {
                if (StringUtils.equals("itemId", ma.getKey())) {
                    itemId = (Long) ma.getValue();
                } else if (StringUtils.equals("saleNum", ma.getKey())) {
                    saleNum = ((BigDecimal) ma.getValue()).longValue();
                }
            }
            map.put(itemId, saleNum);
        });
        
        return map;
    }
}
